<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enviar Información Para Mi Página Web - LocalWebPro</title>
    <meta name="robots" content="noindex, nofollow">

<?php require_once 'files/gtm_head.php'; ?>


    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d',
                        'brand-secondary': '#9e1428',
                        'brand-highlight': '#ffc857',
                        'brand-light-bg': '#f5f5f5',
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a',
                        'brand-light-text': '#f3f4f6',
                        'dark-red-bg': '#9e1428',
                        'dark-black-bg': '#07080a',
                    },
                    fontFamily: { 'sans': ['Barlow', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        html { scroll-behavior: smooth; }
        body { -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; }
        .btn { display: inline-flex; align-items: center; justify-content: center; padding: 0.875rem 2rem; border-radius: 0.5rem; font-weight: 700; font-size: 1rem; text-transform: uppercase; transition: all 0.3s ease; gap: 0.75rem; box-shadow: 0 4px 14px 0 rgba(0,0,0,0.1); cursor: pointer; }
        .btn-primary { background-color: #9e1428; color: #FFFFFF; }
        .btn-primary:hover { background-color: #7f1020; transform: translateY(-3px); box-shadow: 0 7px 20px 0 rgba(0,0,0,0.15); }
        .form-input, .form-textarea {
            width: 100%; padding: 0.75rem 1rem; border: 1px solid #d1d5db; border-radius: 0.5rem; transition: border-color 0.3s, box-shadow 0.3s; font-size: 1rem; background-color: #f9fafb;
        }
        .form-input:focus, .form-textarea:focus {
            outline: none; border-color: #07162d; box-shadow: 0 0 0 3px rgba(7, 22, 45, 0.2);
        }
        .form-label {
            font-weight: 700; margin-bottom: 0.5rem; display: block; color: #374151;
        }
    </style>
</head>
<body class="font-sans bg-brand-light-bg text-brand-dark-text">

<?php require_once 'files/gtm_body.php'; ?>


    <header class="bg-black shadow-sm sticky top-0 z-50">
        <div class="container mx-auto max-w-7xl px-6 h-20 flex items-center justify-between">
            <a href="https://generamasclientes.com" title="Volver A La Página Principal">
                <img src="img/OrozDesignMultimedia.webp"
                     alt="Logo OrozDesign Multimedia" class="h-12 md:h-14 w-auto"
                     onerror="this.onerror=null;this.src='https://placehold.co/250x80/07162d/ffc857?text=Logo';">
            </a>
            <p class="font-bold text-brand-highlight hidden sm:block">
                Paso Principal: Información De Tu Negocio
            </p>
        </div>
    </header>

    <div class="bg-brand-primary text-white py-12 px-4 md:py-16 text-center">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-4xl md:text-5xl font-black uppercase text-brand-highlight">
                Estás a un paso de que empecemos a construir
            </h1>
            <p class="text-xl text-gray-300 mt-4 max-w-3xl mx-auto">
                Gracias de nuevo por tu confianza. Tómate unos 10-15 minutos para completar este formulario. ¡Mientras más detalle nos des, mejor será el resultado final!
            </p>
        </div>
    </div>

    <main class="container mx-auto max-w-7xl px-6 py-16">
        <div class="grid lg:grid-cols-3 gap-8 lg:gap-12">

            <aside class="lg:sticky lg:top-28 self-start">
                <div class="bg-white p-6 rounded-lg shadow-md border">
                    <h3 class="font-black text-xl text-brand-primary uppercase mb-4">Progreso del Formulario</h3>
                    <ol class="space-y-4">
                        <li class="flex items-start gap-3">
                            <span class="flex items-center justify-center h-8 w-8 rounded-full bg-brand-secondary text-white font-bold text-sm flex-shrink-0">1</span>
                            <div>
                                <h4 class="font-bold text-brand-dark-text">Información Personal</h4>
                                <p class="text-sm text-gray-500">Tus datos para mantenernos en contacto.</p>
                            </div>
                        </li>
                        <li class="flex items-start gap-3">
                            <span class="flex items-center justify-center h-8 w-8 rounded-full bg-brand-secondary text-white font-bold text-sm flex-shrink-0">2</span>
                            <div>
                                <h4 class="font-bold text-brand-dark-text">Detalles De Tu Negocio</h4>
                                <p class="text-sm text-gray-500">El corazón de tu nueva página web.</p>
                            </div>
                        </li>
                        <li class="flex items-start gap-3">
                            <span class="flex items-center justify-center h-8 w-8 rounded-full bg-brand-secondary text-white font-bold text-sm flex-shrink-0">3</span>
                            <div>
                                <h4 class="font-bold text-brand-dark-text">Fotos Y Logotipo</h4>
                                <p class="text-sm text-gray-500">Tu logo y fotos para dar vida al sitio.</p>
                            </div>
                        </li>
                    </ol>

                    <div class="mt-6 pt-6 border-t">
                        <img src="img/LocalWebPro.webp" alt="Paquete LocalWebPro" class="rounded-lg">
                        <p class="text-xs text-center text-gray-500 mt-3 font-semibold">El resultado que construiremos con tu información.</p>
                    </div>
                    </div>
                <div class="bg-brand-primary text-white p-6 rounded-lg mt-6">
                    <h4 class="font-bold text-lg flex items-center gap-2"><i data-lucide="help-circle" class="w-5 h-5 text-brand-highlight"></i> ¿Necesitas Ayuda?</h4>
                    <p class="text-gray-300 mt-2 text-sm">Si tienes alguna duda al llenar el formulario, no dudes en contactarnos por WhatsApp. Estamos para ayudarte.</p>
                    <a href="https://wa.me/14257772109" target="_blank" class="text-brand-highlight font-bold mt-3 inline-block hover:underline">Escribirnos Por WhatsApp &rarr;</a>
                </div>
            </aside>

            <div class="lg:col-span-2">
                <form action="procesar_formulario.php" method="POST" enctype="multipart/form-data">

                    <div id="paso-1" class="bg-white p-6 sm:p-8 rounded-lg shadow-md border mb-8">
                        <div class="flex items-center gap-4 mb-6 pb-4 border-b">
                            <i data-lucide="user-circle" class="w-8 h-8 text-brand-secondary"></i>
                            <h2 class="text-2xl font-black text-brand-primary uppercase">1. Tu Información Personal</h2>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="nombre-completo" class="form-label">Tu Nombre Completo</label>
                                <input type="text" id="nombre-completo" name="nombre_completo" class="form-input" placeholder="Ej: Juan Pérez" required>
                            </div>
                            <div>
                                <label for="telefono-personal" class="form-label">Tu Número De Teléfono</label>
                                <input type="tel" id="telefono-personal" name="telefono_personal" class="form-input" placeholder="Ej: 555-123-4567" required>
                            </div>
                        </div>
                        <div class="mt-6">
                            <label for="email-personal" class="form-label">Tu Correo Electrónico</label>
                            <input type="email" id="email-personal" name="email_personal" class="form-input" placeholder="Ej: juan.perez@email.com" required>
                            <p class="text-sm text-gray-500 mt-1">Usaremos este email para enviarte las actualizaciones del proyecto.</p>
                        </div>
                    </div>

                    <div id="paso-2" class="bg-white p-6 sm:p-8 rounded-lg shadow-md border mb-8">
                        <div class="flex items-center gap-4 mb-6 pb-4 border-b">
                            <i data-lucide="briefcase" class="w-8 h-8 text-brand-secondary"></i>
                            <h2 class="text-2xl font-black text-brand-primary uppercase">2. Información De Tu Negocio</h2>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="nombre-negocio" class="form-label">El Nombre De Tu Negocio</label>
                                <input type="text" id="nombre-negocio" name="nombre_negocio" class="form-input" placeholder="Ej: Construcciones Pérez" required>
                            </div>
                            <div>
                                <label for="telefono-negocio" class="form-label">El Teléfono De Tu Negocio</label>
                                <input type="tel" id="telefono-negocio" name="telefono_negocio" class="form-input" placeholder="El que aparecerá en la web">
                            </div>
                        </div>
                        <div class="mt-6">
                            <label for="email-negocio" class="form-label">El Correo De Tu Negocio</label>
                            <input type="email" id="email-negocio" name="email_negocio" class="form-input" placeholder="Ej: contacto@construccionesperez.com">
                        </div>
                        <div class="mt-6">
                            <label for="servicios" class="form-label">Tus Servicios Principales Que Ofrece Tu Negocio</label>
                            <textarea id="servicios" name="servicios" class="form-textarea" rows="5" placeholder="Enumera tus servicios, por ejemplo:&#10;- Remodelación de cocinas&#10;- Instalación de pisos&#10;- Pintura de interiores y exteriores" required></textarea>
                            <p class="text-sm text-gray-500 mt-1">Sé específico. Esto nos ayuda a escribir textos que realmente vendan.</p>
                        </div>
                        <div class="mt-6">
                            <label for="ciudades" class="form-label">Las Ciudades Donde Opera Tu Negocio</label>
                            <textarea id="ciudades" name="ciudades" class="form-textarea" rows="3" placeholder="Enumera las ciudades o áreas de servicio, por ejemplo:&#10;- Houston, TX&#10;- The Woodlands, TX&#10;- Sugar Land, TX" required></textarea>
                            <p class="text-sm text-gray-500 mt-1">Esto es clave para que los clientes locales te encuentren.</p>
                        </div>
                    </div>

                    <div id="paso-3" class="bg-white p-6 sm:p-8 rounded-lg shadow-md border mb-8">
                        <div class="flex items-center gap-4 mb-6 pb-4 border-b">
                            <i data-lucide="image-up" class="w-8 h-8 text-brand-secondary"></i>
                            <h2 class="text-2xl font-black text-brand-primary uppercase">3. Logotipo Y Fotos De Proyectos</h2>
                        </div>
                        <div class="mt-6">
                            <label for="logotipo" class="form-label">Tu Logotipo</label>
                            <p class="text-sm text-gray-500 mb-2">Sube el logo de tu negocio. Si no tienes, no te preocupes, podemos crear un logo con texto profesional para tu web.</p>
                            <input type="file" id="logotipo" name="logotipo" class="form-input" accept="image/png, image/jpeg, image/svg+xml">
                        </div>
                        <div class="mt-8">
                            <label for="fotos" class="form-label">Tus Fotos de Trabajo (Opcional)</label>
                            <p class="text-sm text-gray-500 mb-2">Sube varias fotos de tus proyectos (hasta 10). ¡No te preocupes por la perfección! Las fotos reales de tu trabajo son las que generan más confianza.</p>
                            <input type="file" id="fotos" name="fotos[]" class="form-input" multiple accept="image/png, image/jpeg">
                        </div>
                    </div>

                    <div class="mt-10 text-center">
                         <div class="bg-gray-100 p-4 rounded-lg text-sm text-gray-600 mb-6 flex items-start gap-3">
                            <i data-lucide="lock" class="w-5 h-5 text-gray-400 mt-0.5 flex-shrink-0"></i>
                            <span>Tu información está segura con nosotros y solo se utilizará para la construcción de tu sitio web.</span>
                        </div>
                        <button type="submit" class="btn btn-primary text-lg w-full md:w-auto">
                            <i data-lucide="rocket" class="w-6 h-6"></i>
                            ¡Enviar Para Empezar Mi Web!
                        </button>
                    </div>
                </form>
            </div>

        </div>
    </main>
    
<?php require_once 'files/footer.php'; ?>


    <script>
        document.addEventListener('DOMContentLoaded', () => {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
            const yearEl = document.getElementById('year');
            if (yearEl) {
                yearEl.textContent = new Date().getFullYear();
            }
        });
    </script>
</body>
</html>