<!DOCTYPE html>
<html lang="es">
<head>
        <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>Página Web Para Negocios Locales En Estados Unidos | LocalWebPro Por Solo $197</title>
    <meta name="description" content="Consigue una página web profesional en Estados Unidos diseñada para atraer clientes. Paquete todo incluido por $197 para dueños de negocios locales. ¡Garantía de Cero Riesgo!">
    
<?php require_once 'files/gtm_head.php'; ?>


    <link rel="icon" href="img/favicon.webp" sizes="any">
    <link rel="icon" href="img/favicon.webp" type="image/svg+xml">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.webp">
    
    <link rel="canonical" href="https://generamasclientes.com/oferta-web">

    <meta property="og:title" content="Página Web Profesional para tu Negocio Local por Solo $197">
    <meta property="og:description" content="Deja de ser invisible online. Atrae clientes y genera confianza con una web diseñada para vender.">
    <meta property="og:image" content="https://generamasclientes.com/oferta-web/img/LocalWebPro.webp">
    <meta property="og:url" content="https://generamasclientes.com/oferta-web">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="LocalWebPro">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Página Web Profesional para tu Negocio Local por Solo $197">
    <meta name="twitter:description" content="Deja de ser invisible online. Atrae clientes y genera confianza con una web diseñada para vender.">
    <meta name="twitter:image" content="https://generamasclientes.com/oferta-web/img/LocalWebPro.webp"> 

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js" defer></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d', /* Azul Oscuro (Inteligencia) */
                        'brand-secondary': '#9e1428', /* Rojo (Creatividad) */
                        'brand-highlight': '#ffc857', /* Amarillo (Visión) */
                        'brand-light-bg': '#f5f5f5', /* Blanco (Honestidad) */
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a', /* Negro (Prestigio) - para textos principales */
                        'brand-light-text': '#f3f4f6', /* Mantener para textos claros sobre fondos oscuros */
                        'dark-red-bg': '#9e1428', /* Usar Rojo Secundario para fondos específicos */
                        'dark-black-bg': '#07080a', /* Nuevo: Negro (Prestigio) para fondos */
                    },
                    fontFamily: { 'sans': ['Barlow', 'sans-serif'] }
                }
            }
        }
    </script>


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "LocalWebPro - OrozDesign Multimedia",
  "image": "https://generamasclientes.com/oferta-web/img/LocalWebPro.webp",
  "@id": "https://generamasclientes.com",
  "url": "https://generamasclientes.com",
  "telephone": "+1-425-243-4579",
  "priceRange": "$",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Seattle",
    "addressLocality": "Seattle",
    "addressRegion": "WA",
    "postalCode": "98201",
    "addressCountry": "US"
  },
  "description": "Ayudamos a dueños de negocios locales a atraer más clientes y generar confianza con una página web profesional. Ofrecemos diseño web, dominio, hosting y soporte.",
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "opens": "09:00",
    "closes": "17:00"
  },
  "sameAs": [
    "https://www.facebook.com/orozdesign"
  ] 
}
</script>

<style>
/* --- ESTILOS GENERALES Y ANIMACIONES --- */
html { 
    scroll-behavior: smooth;
    overflow-x: hidden;
}
body { 
    -webkit-font-smoothing: antialiased; 
    -moz-osx-font-smoothing: grayscale; 
}
.btn { 
    display: inline-flex; 
    align-items: center; 
    justify-content: center; 
    padding: 0.875rem 2rem; 
    border-radius: 0.5rem; 
    font-weight: 700; 
    font-size: 1rem; 
    text-transform: uppercase; 
    transition: all 0.3s ease; 
    gap: 0.75rem; 
    box-shadow: 0 4px 14px 0 rgba(0,0,0,0.1); 
}
.btn-primary { 
    background-color: #9e1428; 
    color: #FFFFFF; 
}
.btn-primary:hover { 
    background-color: #7f1020; 
    transform: translateY(-3px); 
    box-shadow: 0 7px 20px 0 rgba(0,0,0,0.15); 
}
.btn-highlight { 
    background-color: #ffc857; 
    color: #07080a; 
}
.btn-highlight:hover { 
    background-color: #e6b04e; 
    transform: translateY(-3px); 
    box-shadow: 0 7px 20px 0 rgba(0,0,0,0.15); 
}
.btn-pulse { 
    animation: pulse-btn 2s infinite ease-in-out; 
}

/* --- ESTILOS PARA COMPONENTES ESPECÍFICOS --- */
#back-to-top { 
    position: fixed; 
    bottom: 7rem; 
    right: 1.5rem; 
    background-color: #07162d; 
    color: #ffc857; 
    padding: 1rem; 
    border-radius: 9999px; 
    box-shadow: 0 4px 14px 0 rgba(0,0,0,0.2); 
    display: none; /* Se controla con JS */
    align-items: center; 
    justify-content: center; 
    cursor: pointer; 
    transition: opacity 0.3s ease-in-out, transform 0.3s ease-in-out; 
    opacity: 0; 
    visibility: hidden; 
    z-index: 999; 
}
#back-to-top.show { 
    display: flex;
    opacity: 1; 
    visibility: visible; 
    transform: translateY(0); 
}
#back-to-top:hover { 
    transform: translateY(-3px); 
    box-shadow: 0 7px 20px 0 rgba(0,0,0,0.25); 
}
@media (min-width: 768px) { 
    #back-to-top { bottom: 1.5rem; } 
}

/* --- ESTILOS PARA LA NOTIFICACIÓN DE PRUEBA SOCIAL --- */
#social-proof-toast {
    opacity: 0;
    transform: translateY(100%) translateX(-50%);
    transition: all 0.5s ease-in-out;
}
@media (min-width: 640px) {
    #social-proof-toast {
        transform: translateY(100%) translateX(0);
    }
}
#social-proof-toast.show {
    opacity: 1;
    transform: translateY(0) translateX(-50%);
}
@media (min-width: 640px) {
    #social-proof-toast.show {
        transform: translateY(0) translateX(0);
    }
}

/* --- ANIMACIONES (Keyframes) --- */
@keyframes slideUp { 
    to { transform: translateY(0); } 
}
@keyframes pulse-btn { 
    0% { transform: scale(1); box-shadow: 0 4px 14px 0 rgba(0,0,0,0.1); } 
    50% { transform: scale(1.02); box-shadow: 0 7px 20px 0 rgba(0,0,0,0.15); } 
    100% { transform: scale(1); box-shadow: 0 4px 14px 0 rgba(0,0,0,0.1); } 
}
@keyframes wave-hand {
    0% { transform: rotate(0deg); } 15% { transform: rotate(14deg); } 30% { transform: rotate(-8deg); } 45% { transform: rotate(14deg); } 60% { transform: rotate(-4deg); } 75% { transform: rotate(10deg); } 100% { transform: rotate(0deg); }
}
.animate-wave-hand {
    animation: wave-hand 2.5s infinite ease-in-out;
    transform-origin: 70% 70%;
}
@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}
.animate-fade-in {
    animation: fadeIn 0.3s ease-out;
}
@keyframes slideIn { 
    from { transform: translateX(8%); opacity: .6 } 
    to { transform: translateX(0); opacity: 1 } 
}
</style>

</head>
<body class="font-sans bg-brand-light-bg text-brand-dark-text overflow-x-hidden">

<?php require_once 'files/gtm_body.php'; ?>


<div id="topbar" class="fixed inset-x-0 top-0 z-50 bg-brand-primary/95 border-b border-white/10 backdrop-blur">
    <div class="mx-auto max-w-7xl px-4 sm:px-6">
        <div class="h-16 md:h-20 flex items-center justify-between">
            <a href="#hero-section" class="flex items-center gap-3" aria-label="Ir al inicio">
                <img src="img/OrozDesignMultimedia.webp" alt="OrozDesign Multimedia" class="h-8 md:h-10 w-auto object-contain" loading="eager">
            </a>

            <nav class="hidden md:flex items-center gap-6 font-extrabold uppercase tracking-wide text-white">
                <a href="#paquete" class="inline-flex items-center gap-1 hover:text-brand-highlight">
                    <i data-lucide="package" class="lucide-icon"></i>Que Incluye
                </a>
                <a href="#solucion-advanced" class="inline-flex items-center gap-1 hover:text-brand-highlight">
                    <i data-lucide="sparkles" class="lucide-icon"></i>Beneficios
                </a>
                <a href="#oferta-irresistible" class="inline-flex items-center gap-1 hover:text-brand-highlight">
                    <i data-lucide="wallet" class="lucide-icon"></i>Oferta
                </a>
                <a href="#ai-tools" class="inline-flex items-center gap-1 hover:text-brand-highlight">
                    <i data-lucide="gift" class="lucide-icon"></i>Bonus
                </a>
                <a href="#testimonials-section" class="inline-flex items-center gap-1 hover:text-brand-highlight">
                    <i data-lucide="users" class="lucide-icon"></i>Clientes
                </a>
                <a href="#payment-section" class="inline-flex items-center gap-2 bg-brand-highlight text-brand-dark-text px-4 py-2 rounded-lg font-black hover:opacity-90">
                    Adquirir por $197 <i data-lucide="arrow-right" class="lucide-icon"></i>
                </a>
            </nav>
            <button id="menu-toggle" class="md:hidden inline-flex items-center justify-center px-3 py-2 rounded-lg bg-brand-highlight text-brand-dark-text font-black">
                <i data-lucide="menu" class="lucide-icon"></i>
            </button>
        </div>
    </div>
</div>

<div id="mobile-menu" class="fixed inset-0 z-[60] hidden">
    <div id="mm-backdrop" class="absolute inset-0 bg-black/60 backdrop-blur-sm"></div>

    <aside class="relative w-full h-full bg-[#0B1B31] text-white flex flex-col animate-fade-in">
        <div class="p-4 border-b border-white/10 flex items-center justify-between flex-shrink-0">
            <span class="text-xs font-semibold tracking-widest uppercase text-brand-highlight">Oferta Por Tiempo Limitado</span>
            <button id="mm-close" class="p-2 rounded-md hover:bg-white/10"><i data-lucide="x" class="lucide-icon"></i></button>
        </div>

        <div class="flex-grow p-6 text-center overflow-y-auto">
            <div class="w-full max-w-sm mx-auto">
                <img src="img/Paquete-Web.webp" alt="Paquete Web LocalWebPro" class="w-full h-auto rounded-xl ring-1 ring-white/10 mb-4" loading="lazy">
                <h3 class="text-2xl font-black leading-tight uppercase">Tu web lista para vender</h3>
                <p class="mt-2 text-sm text-gray-300">Profesional, Rápida y Optimizada Para Convertir Clientes</p>

                <ul class="mt-4 space-y-2 text-sm text-gray-200 inline-block text-left">
                    <li class="flex items-start gap-2"><i data-lucide="check-circle" class="lucide-icon"></i> Diseño Enfocado En Ventas</li>
                    <li class="flex items-start gap-2"><i data-lucide="zap" class="lucide-icon"></i> Carga Rápida En Móvil</li>
                    <li class="flex items-start gap-2"><i data-lucide="shield-check" class="lucide-icon"></i> Sin Contratos Ni Cargos Ocultos</li>
                </ul>

                <a href="#payment-section" class="mt-5 inline-flex w-full justify-center items-center gap-2 px-5 py-3 text-base font-extrabold rounded-xl bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/30 hover:opacity-95">
                    <i data-lucide="shopping-bag" class="lucide-icon"></i> ADQUIRIR MI PÁGINA WEB
                </a>

                <nav class="mt-6 pt-6 border-t border-white/10">
                    <ul class="space-y-1 text-base font-bold">
                        <li>
                            <a href="#paquete" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="package" class="lucide-icon"></i>Que Incluye El Paquete
                            </a>
                        </li>
                        <li>
                            <a href="#solucion-advanced" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="sparkles" class="lucide-icon"></i>Los Beneficios Que Adquieres
                            </a>
                        </li>
                        <li>
                            <a href="#oferta-irresistible" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="wallet" class="lucide-icon"></i>Nuestra Oferta Especial
                            </a>
                        </li>
                        <li>
                            <a href="#ai-tools" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="gift" class="lucide-icon"></i>Los Bonus Gratis Y Limitados
                            </a>
                        </li>
                        <li>
                            <a href="#testimonials-section" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="users" class="lucide-icon"></i>Algunos Clientes Satisfechos
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>
    </aside>
</div>

<header id="hero-section"
  class="relative text-white flex items-center justify-center overflow-hidden pt-36 md:pt-48"
  style="
    background-image:
      radial-gradient(900px 420px at 50% 0%, rgba(255,200,87,.08), transparent 60%),
      linear-gradient(rgba(7,22,45,.82), rgba(7,22,45,.82)),
      url('img/BG01.webp');
    background-size: cover; background-position: center; " data-aos="fade-up" loading="lazy">
    
    <div class="relative z-10 w-full">
        <div class="container mx-auto max-w-5xl px-6 py-20 md:py-28 text-center">
            <p class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 text-brand-highlight font-semibold tracking-widest uppercase ring-1 ring-white/20" data-aos="fade-up" data-aos-delay="60">
                <i data-lucide="radar" class="lucide-icon"></i>
                Vimos que te interesó nuestra solución... ¡Ahora la pregunta es simple!
            </p>
            <h1 class="mt-5 font-black uppercase tracking-tight leading-[1.05] text-4xl sm:text-6xl md:text-7xl" data-aos="fade-up" data-aos-delay="140">
                ¿Seguir siendo invisible<br class="hidden sm:inline"> o <span class="text-brand-highlight">empezar a atraer clientes?</span>
            </h1>
            <p class="mt-5 text-lg md:text-xl text-gray-200 max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="220">
                Esta es tu <b>ÚLTIMA OPORTUNIDAD</b> para conseguir una página web profesional que trabaje para ti 24/7, antes de que esta oferta desaparezca para siempre.
            </p>
            <div class="mt-9 flex justify-center" data-aos="fade-up" data-aos-delay="300">
                <a href="#payment-section" class="inline-flex justify-center items-center gap-2 px-7 py-4 text-base sm:text-lg font-extrabold rounded-xl bg-brand-highlight text-[#07162D] shadow-xl shadow-black/20 ring-2 ring-brand-highlight/60 hover:translate-y-[1px] hover:shadow-lg hover:opacity-95 transition w-full sm:w-auto">
                    <i data-lucide="shopping-bag" class="lucide-icon"></i> ¡SÍ, QUIERO MI ÚLTIMA OPORTUNIDAD!
                </a>
            </div>
            <div class="mt-6 flex flex-col sm:flex-row gap-2 sm:gap-4 items-center justify-center text-sm text-gray-300" data-aos="fade-up" data-aos-delay="360">
                <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="lucide-icon"></i> Garantía Cero Riesgo</span>
                <span class="hidden sm:inline">•</span>
                <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="lucide-icon"></i> Entrega Rápida</span>
                <span class="hidden sm:inline">•</span>
                <span class="inline-flex items-center gap-1.5"><i data-lucide="trending-up" class="lucide-icon"></i> Diseño Que Vende</span>
            </div>
        </div>
    </div>
    <div class="pointer-events-none absolute inset-x-0 bottom-0 h-24 bg-gradient-to-t from-[#07162D] to-transparent"></div>
</header>

<main>
    

<section id="solucion-advanced" class="relative bg-brand-light-bg py-16 md:py-24 overflow-hidden" data-aos="fade-up">
    <div class="pointer-events-none absolute -top-20 -left-16 w-72 h-72 rounded-full bg-brand-secondary/10 blur-3xl"></div>
    <div class="pointer-events-none absolute -bottom-24 -right-20 w-80 h-80 rounded-full bg-brand-highlight/10 blur-3xl"></div>

    <div class="container mx-auto max-w-7xl px-6">
        <div class="text-center max-w-4xl mx-auto">
            <p class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full
                 bg-brand-highlight/90 text-brand-primary font-semibold tracking-widest uppercase
                 ring-1 ring-brand-primary/10">
                <i data-lucide="radar" class="lucide-icon"></i>
                Proceso simple • Resultados medibles • Sin complicaciones
            </p>
            <h2 class="mt-3 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-brand-primary uppercase leading-tight">
                En 3 pasos te ponemos frente a quienes <span class="text-brand-secondary">ya te están buscando</span>
            </h2>
            <div class="mt-6 w-24 h-1.5 mx-auto rounded-full bg-brand-secondary"></div>
            <p class="mt-4 text-base md:text-lg text-brand-dark-text/70">
                Nos Encargamos De Lo Técnico; Tú Te Encargas De Atender Las Solicitudes De Clientes Potenciales
            </p>
        </div>

        <div class="mt-12 sm:mt-14 grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8 lg:gap-10">

            <article class="group relative text-center bg-white/95 p-6 sm:p-7 md:p-8 rounded-2xl
                     shadow-sm hover:shadow-xl hover:-translate-y-0.5 transition
                     ring-1 ring-gray-200">
                <div class="relative mx-auto mb-6 w-20 h-20 rounded-2xl bg-brand-highlight/90 ring-2 ring-brand-highlight/20 flex items-center justify-center">
                    <i data-lucide="file-text" class="lucide-icon-xl text-brand-primary"></i>
                    <span class="absolute -top-2 -left-2 text-xs font-black bg-brand-secondary text-white rounded-full px-2 py-1 uppercase">Paso 1</span>
                </div>
                <h3 class="text-xl sm:text-2xl font-black mb-2 text-brand-dark-text uppercase">
                    Envíanos tus datos clave de tu negocio
                </h3>
                <p class="text-[15px] sm:text-base md:text-lg text-gray-600">
                    Servicios, zonas que atiendes y contacto. <span class="font-semibold">Información Clave Y Precisa</span> para iniciar tu proyecto, sin reuniones eternas.
                </p>
            </article>

            <article class="group relative text-center bg-white/95 p-6 sm:p-7 md:p-8 rounded-2xl
                     shadow-sm hover:shadow-xl hover:-translate-y-0.5 transition
                     ring-1 ring-gray-200">
                <div class="relative mx-auto mb-6 w-20 h-20 rounded-2xl bg-brand-highlight/90 ring-2 ring-brand-highlight/20 flex items-center justify-center">
                    <i data-lucide="monitor-dot" class="lucide-icon-xl text-brand-primary"></i>
                    <span class="absolute -top-2 -left-2 text-xs font-black bg-brand-secondary text-white rounded-full px-2 py-1 uppercase">Paso 2</span>
                </div>
                <h3 class="text-xl sm:text-2xl font-black mb-2 text-brand-dark-text uppercase">
                    Diseñamos tu página web que vende tus servicios
                </h3>
                <p class="text-[15px] sm:text-base md:text-lg text-gray-600">
                    Aplicamos nuestra <span class="font-semibold">Estructura Probada</span>, mensajes claros y enfoque en conversión para que tu marca inspire confianza desde el primer clic.
                </p>
            </article>

            <article class="group relative text-center bg-white/95 p-6 sm:p-7 md:p-8 rounded-2xl
                     shadow-sm hover:shadow-xl hover:-translate-y-0.5 transition
                     ring-1 ring-gray-200">
                <div class="relative mx-auto mb-6 w-20 h-20 rounded-2xl bg-brand-highlight/90 ring-2 ring-brand-highlight/20 flex items-center justify-center">
                    <i data-lucide="check-circle" class="lucide-icon-xl text-brand-primary"></i>
                    <span class="absolute -top-2 -left-2 text-xs font-black bg-brand-secondary text-white rounded-full px-2 py-1 uppercase">Paso 3</span>
                </div>
                <h3 class="text-xl sm:text-2xl font-black mb-2 text-brand-dark-text uppercase">
                    Publicamos Tu Web y empiezas a ganar visibilidad
                </h3>
                <p class="text-[15px] sm:text-base md:text-lg text-gray-600">
                    Entregamos tu web lista. Tu marca se verá <span class="font-semibold">Profesional y confiable</span>, y comienzas a recibir más consultas de clientes potenciales.
                </p>
            </article>
        </div>
    </div>
</section>

<section id="paquete" class="relative py-20 md:py-24 text-brand-light-text overflow-hidden"
  data-aos="fade-up"
  style="background-image: linear-gradient(rgba(7,22,45,.92), rgba(7,22,45,.92)), url('img/BG02.webp?auto=compress&cs=tinysrgb&w=1260&h=800&dpr=1'); background-size: cover; background-position: center;" loading="lazy">

  <div class="container mx-auto max-w-7xl px-6 relative z-10">
    <div class="flex justify-center">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-white/90 text-brand-secondary font-bold tracking-widest uppercase
                 ring-1 ring-white/15 text-sm md:text-base text-center">
        <i data-lucide="zap" class="w-4 h-4"></i>
        Olvídate de la tecnología — nosotros lo hacemos fácil
      </p>
    </div>

    <h3 class="mt-4 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-center text-white uppercase leading-tight max-w-4xl mx-auto">
      Tu paquete <span class="text-brand-highlight">LocalWeb Pro</span><br class="hidden md:inline" />
      todo listo para que te encuentren y te contacten
    </h3>

    <div class="mt-6 flex flex-wrap gap-2 justify-center">
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="globe" class="w-4 h-4"></i> Dominio .com Incluido
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="server" class="w-4 h-4"></i> Hosting Seguro y Compartido
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="shield-check" class="w-4 h-4"></i> SSL (Candado) De Seguridad
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="pen-tool" class="w-4 h-4"></i> Textos Que Venden
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="smartphone" class="w-4 h-4"></i> 100% Móvil
      </span>
    </div>

    <div class="mt-10 max-w-3xl mx-auto" data-aos="zoom-in">
      <img src="img/Paquete-Web.webp"
           alt="Paquete LocalWebPro"
           class="rounded-xl w-full h-auto object-cover" loading="lazy">
    </div>

    <div class="mt-12 grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-10 max-w-5xl mx-auto">
      <ul class="space-y-6 text-base sm:text-lg">
        <li class="flex items-start gap-4">
          <i data-lucide="pencil" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Redacción Estratégica Que Vende:</strong>
            <p class="text-gray-300">Mensajes claros y persuasivos para que entiendan tu valor en segundos y te contacten sin dudar.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="globe" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Dominio Profesional Con Tu Nombre:</strong>
            <p class="text-gray-300">Ejemplo: <em>tunegocio.com</em>. Proyecta seriedad y propiedad de marca desde el primer vistazo.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="server" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Alojamiento Rápido y Compartido:</strong>
            <p class="text-gray-300">Cargas veloces y protección activa. No pierdas clientes por lentitud o errores técnicos.</p>
          </div>
        </li>
      </ul>

      <ul class="space-y-6 text-base sm:text-lg">
        <li class="flex items-start gap-4">
          <i data-lucide="shield-check" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Certificado SSL De Seguridad:</strong>
            <p class="text-gray-300">El candado que protege datos y mejora tu posicionamiento. Seguridad visible para tus clientes.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="smartphone" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Diseño 100% Responsive:</strong>
            <p class="text-gray-300">Se ve perfecto en celular, tablet y computadora. Ninguna oportunidad se escapa.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="messages-square" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Acompañamiento y Soporte Técnico:</strong>
            <p class="text-gray-300">Respuestas simples, sin tecnicismos. Te guiamos hasta que quedes 100% conforme.</p>
          </div>
        </li>
      </ul>
    </div>

    <div class="mt-12 text-center">
      <a href="#payment-section"
         class="inline-flex items-center justify-center gap-2 px-8 py-4 text-lg font-extrabold rounded-2xl
                bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/30
                hover:opacity-95 hover:translate-y-[1px] transition">
        ¡QUIERO MI PAQUETE LOCALWEB PRO! <i data-lucide="arrow-right" class="w-5 h-5"></i>
      </a>
      <p class="mt-3 text-sm text-gray-300 flex flex-wrap items-center justify-center gap-x-3 gap-y-1">
        <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4"></i> Sin Contratos</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="w-4 h-4"></i> Entrega Rápida</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="sparkles" class="w-4 h-4"></i> Por Solo $197</span>
      </p>
    </div>
  </div>
</section>

<section id="ai-tools" class="py-20 md:py-24 bg-dark-black-bg text-brand-light-text" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6">
    
    <!-- Encabezado -->
    <div class="text-center max-w-5xl mx-auto mb-12">
      <p class="text-sm sm:text-base md:text-2xl font-bold text-brand-highlight uppercase tracking-widest mb-4 md:mb-6 animate-pulse">
        Pero espera, la oferta se pone aún mejor...
      </p>

      <div class="flex items-center justify-center gap-3 md:gap-4 mb-2">
        <i data-lucide="gift" class="w-6 h-6 md:w-8 md:h-8 text-brand-highlight"></i>
        <span class="text-brand-highlight text-3xl sm:text-4xl md:text-6xl font-black uppercase">BONUS INSUPERABLE</span>
      </div>

      <h3 class="text-2xl sm:text-3xl md:text-5xl font-black text-brand-white uppercase leading-tight">
        Tu propia agencia mini de marketing 24/7<br class="hidden md:block" />impulsada con inteligencia artificial
      </h3><br />
      
            <!-- Badge de valor reforzado -->
      <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full ring-2 ring-white/90 bg-brand-secondary/90 mb-3">
        <i data-lucide="badge-dollar-sign" class="w-5 h-5 text-brand-highlight"></i>
        <span class="text-xs sm:text-sm md:text-base font-extrabold tracking-wider text-white uppercase">
          Valorado en <span class="line-through opacity-80">$497</span> — incluido hoy sin costo
        </span>
      </div>

    </div>

    <!-- Tarjetas -->
    <div class="mt-10 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
      
      <!-- Card 1 -->
      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up">
        <!-- Imagen con proporción y badge -->
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-PlanificadorMarketing.webp" alt="Oferta Marketing IA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <!-- Contenido -->
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Planificador de Objetivos de Marketing </h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Un Plan Semanal, Mensual O Trimestral Paso A Paso</p>
          <p class="text-base md:text-lg text-gray-300">
            Deja de improvisar y empieza a crecer con un plan claro. Esta herramienta usa IA para crear un plan de marketing estratégico para ti. No tendrás que adivinar qué hacer a continuación.
          </p>
        </div>
      </article>

      <!-- Card 2 -->
      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="100">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-AnunciosPublicitarios.webp" alt="MarketingIA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Generador de Anuncios Publicitarios </h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Textos De Anuncios Que Realmente Venden Para Tus Servicios</p>
          <p class="text-base md:text-lg text-gray-300">
            Transforma tus servicios en anuncios que atraen clientes. Olvídate de adivinar qué funciona y obtén textos persuasivos y listos para usar en tus campañas.
          </p>
        </div>
      </article>

      <!-- Card 3 -->
      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="200">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-PublicacionesSociales.webp" alt="MarketingIA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Creador de Publicaciones Sociales </h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Posts Que Abordan El Problema, La Solución Y Tu Servicio</p>
          <p class="text-base md:text-lg text-gray-300">
            Nunca te quedes sin ideas para tus redes sociales. Genera textos que captan la atención de tus clientes ideales, muestran tu valor y te posicionan.
          </p>
        </div>
      </article>

      <!-- Card 4 -->
      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="300">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-SeguimientoProspectos.webp" alt="MarketingIA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
        <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Asistente de Seguimiento para Prospectos</h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Mensajes Para Convertir De Clientes Potenciales En Clientes</p>
          <p class="text-base md:text-lg text-gray-300">
            Cierra ventas después de cotizar con secuencias de seguimiento persuasivas y claras que responden objeciones.
          </p>
        </div>
      </article>

      <!-- Card 5 -->
      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="400">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-CotizacionesDigitales.webp" alt="MarketingIA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Generador de Cotizaciones Digitales</h4>
          <p class="text-brand-highlight leading-snug font-black">Genera Cotizaciones Profesionales En PDF En Menos De Un Minuto</p>
          <p class="text-base md:text-lg text-gray-300">
            Proyecta una imagen profesional y acelera el proceso de venta. Crea cotizaciones con tu marca de forma rápida y sencilla.
          </p>
        </div>
      </article>

      <!-- Card 6 -->
      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="500">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-FacturasDigitales.webp" alt="MarketingIA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Generador de Facturas Digitales </h4>
          <p class="text-brand-highlight leading-snug font-black">Genera Facturas Profesionales Para Tus Servicios Fácilmente</p>
          <p class="text-base md:text-lg text-gray-300">
            Emite facturas en PDF con tu marca y cobra a tiempo. Orden y confianza para ti y tus clientes.
          </p>
        </div>
      </article>

    </div>

    <!-- Bloque de urgencia -->
    <div class="text-center mt-12 md:mt-16 max-w-3xl mx-auto" data-aos="zoom-in" data-aos-delay="100">
      <div class="bg-brand-secondary border border-red-500/60 rounded-2xl p-6 md:p-8">
        <h4 class="text-2xl md:text-3xl font-black text-red-300 mb-2 uppercase">Esto es lo que pierdes si no actúas hoy</h4>
        <p class="text-base sm:text-lg md:text-xl text-red-200">
          No es solo el descuento de <span class="font-bold text-red-100">$497</span> en herramientas. Es seguir sin claridad diaria, sin mensajes que venden y sin materiales profesionales que te den ventaja.
          <br><span class="font-bold">AVANZAS HOY O SIGUES IGUAL. TÚ DECIDES</span>
        </p>

        <!-- Barra de escasez (manteniendo tu estilo) -->
        <div class="mt-5">
          <div class="flex items-center justify-between text-xs sm:text-sm text-red-200 font-semibold mb-2">
            <span>Disponibles Todavía</span>
            <span>12 / 50</span>
          </div>
          <div class="w-full h-2.5 bg-white rounded-full overflow-hidden ring-1 ring-red-500/50">
            <div class="h-full bg-brand-highlight" style="width:74%"></div>
          </div>
        </div>

        <!-- Cupos (más urgencia visual) -->
        <div class="mt-4 inline-flex items-center gap-2 px-5 py-2 rounded-full bg-white ring-1 ring-red-400/70 animate-pulse">
          <i data-lucide="flame" class="w-5 h-5 text-black"></i>
          <span class="text-lg md:text-2xl font-extrabold text-black tracking-wide">
            ¡Quedan Solo <del class="opacity-60 mx-1">50</del> 12 Cupos!
          </span>
        </div>
      </div>
    </div>

    <!-- CTA -->
    <div class="text-center mt-10">
      <a href="#payment-section" class="inline-flex items-center gap-2 px-8 py-4 text-xl font-extrabold rounded-2xl
                                       bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/30
                                       hover:opacity-95 hover:translate-y-[1px] transition">
        ¡NO ME QUIERO PERDER ESTA OFERTA! <i data-lucide="arrow-right" class="w-6 h-6"></i>
      </a>
    </div>
    
     <!-- Meta inferior -->
    <div class="mt-4 text-xs sm:text-sm text-white flex flex-wrap items-center justify-center gap-x-4 gap-y-1">
      <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4"></i> Pago Seguro</span>
      <span class="inline-flex items-center gap-1.5"><i data-lucide="headphones" class="w-4 h-4"></i> Acompañamiento Experto</span>
      <span class="inline-flex items-center gap-1.5"><i data-lucide="check-circle-2" class="w-4 h-4"></i> Sin Contratos</span>
    </div>
    
  </div>
</section>

<section id="course-bonus" class="py-20 md:py-24 text-brand-light-text relative overflow-hidden"
  style="
    background-image:
      linear-gradient(rgba(7,22,45,.92), rgba(7,22,45,.92)),
      url('img/BG02.webp?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');
    background-size: cover; background-position: center;"
  data-aos="fade-up" loading="lazy">

  <!-- halo decorativo -->
  <div class="pointer-events-none absolute -top-24 -left-24 w-72 h-72 bg-brand-highlight/14 rounded-full blur-3xl"></div>

  <div class="container mx-auto max-w-7xl px-6 relative z-10">
    <!-- Encabezado -->
    <div class="text-center max-w-4xl mx-auto">
      <!-- Pill superior -->
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-brand-secondary/90 text-brand-highlight font-bold tracking-widest uppercase
                 ring-1 ring-brand-highlight/30 shadow-sm text-sm md:text-base mb-3"
         data-aos="fade-up">
        <i data-lucide="gift" class="w-4 h-4 md:w-5 md:h-5"></i>
        Y por si fuera poco... un bonus Gratis más
      </p>

      <!-- Título -->
      <h2 class="font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-white uppercase leading-tight
                 drop-shadow-[0_2px_16px_rgba(0,0,0,.35)]"
          data-aos="fade-up" data-aos-delay="80">
        Deja de depender de otros y Domina <span class="text-brand-highlight">el marketing</span> de tu propio negocio
      </h2>
    </div>

    <!-- Contenido -->
    <div class="mt-12 md:mt-16 grid lg:grid-cols-2 gap-8 lg:gap-12 items-center">
      <!-- Imagen con marco -->
      <div data-aos="fade-right">
        <div class="relative bg-white/5 ring-1 ring-white/10 rounded-2xl p-2 md:p-3 shadow-2xl">
          <img src="img/Domina-El-Marketing.webp"
               alt="Curso Domina El Marketing De Tu Negocio"
               class="w-full h-auto rounded-xl object-cover" loading="lazy">
        </div>
      </div>

      <!-- Card del curso -->
      <div data-aos="fade-left">
        <div class="bg-brand-primary/85 backdrop-blur-sm p-6 sm:p-8 rounded-2xl shadow-xl ring-1 ring-white/10">
          <div class="flex items-start gap-4">
            <i data-lucide="graduation-cap" class="w-8 h-8 text-brand-highlight"></i>
            <div>
              <p class="text-sm sm:text-base font-semibold text-brand-highlight uppercase">Bonus #2 - Curso Exclusivo Si Adquieres HOY</p>
              <h3 class="text-2xl sm:text-3xl font-black text-white uppercase leading-tight">
                Domina el marketing de tu negocio en menos de 24 horas
              </h3>
            </div>
          </div>

          <p class="text-base sm:text-lg text-gray-300 mt-4">
            En este curso práctico y directo, aprenderás a:
          </p>

          <ul class="mt-4 space-y-3 text-base sm:text-lg text-gray-200">
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Definir Una Estrategia Clara</strong> para dejar de improvisar y saber qué hacer cada día.</span>
            </li>
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Escribir Anuncios y Publicaciones</strong> que realmente atraen a los clientes que buscas.</span>
            </li>
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Crear Contenido Para Tus Redes Sociales</strong> que conecte con tu audiencia y te posicione como experto.</span>
            </li>
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Usar La Inteligencia Artificial</strong> como tu asistente personal para ahorrarte horas de trabajo.</span>
            </li>
          </ul>

          <!-- Valor vs Precio -->
          <div class="mt-8 grid grid-cols-2 overflow-hidden rounded-xl ring-1 ring-brand-highlight/30">
            <div class="p-4 text-center bg-white/5">
              <p class="text-xs sm:text-sm font-bold text-gray-400 uppercase">Valor real</p>
              <p class="text-3xl sm:text-5xl font-bold text-gray-500 line-through decoration-2">$250</p>
            </div>
            <div class="p-4 text-center bg-brand-highlight/10 animate-pulse">
              <p class="text-xs sm:text-sm font-bold text-brand-highlight uppercase">Precio para ti</p>
              <p class="text-3xl sm:text-5xl font-black text-brand-highlight">GRATIS</p>
            </div>
          </div>

          <!-- Urgencia -->
          <div class="mt-6 text-center">
            <p class="inline-block bg-brand-secondary text-red-100 font-extrabold text-lg md:text-xl px-5 py-2 rounded-full ring-1 ring-red-500/70">
              GRATIS Si Adquieres Tu Página Web HOY 
            </p>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>
        
<section id="oferta-irresistible" class="py-20 md:py-24 bg-brand-light-bg">
  <div class="container mx-auto max-w-4xl px-4 sm:px-6">

    <div class="relative overflow-visible">
      <div class="bg-white rounded-2xl shadow-2xl border-t-8 border-brand-secondary p-6 sm:p-8 md:p-12 relative">

        <div class="text-center">
          <div class="flex flex-col items-center gap-3 mb-3">
            <i data-lucide="shield-check" class="w-14 h-14 md:w-16 md:h-16 text-brand-secondary"></i>
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-brand-dark-text uppercase leading-tight">
              Nuestra garantía de <br />cero riesgo para tu tranquilidad
              <span class="block text-xl sm:text-2xl md:text-3xl font-extrabold text-gray-600 normal-case mt-1">
                (LA QUE NADIE MÁS PUEDE OFRECERTE)
              </span>
            </h2>
          </div>

          <div class="mt-4 w-24 h-1.5 mx-auto rounded-full bg-brand-highlight"></div>

          <p class="text-base sm:text-lg md:text-xl text-gray-600 max-w-2xl mx-auto mt-6">
            Entendemos la desconfianza por malas experiencias que has tenido en el pasado. Por eso, en lugar de pedirte que confíes en nuestras palabras, te pedimos que confíes en tus propios ojos.
          </p>

          <div class="mt-8 grid grid-cols-1 md:grid-cols-3 gap-5 items-stretch">
            <div class="relative bg-slate-50 rounded-2xl ring-2 ring-brand-secondary/60 p-6 flex flex-col justify-center shadow-xl">
              <span class="absolute -top-4 left-1/2 -translate-x-1/2 px-4 py-1.5 rounded-full bg-brand-secondary text-white text-sm font-bold shadow">
                OFERTA DE HOY
              </span>
              <p class="text-7xl sm:text-8xl font-black text-brand-secondary leading-none mt-4">$27</p>
              <p class="text-lg font-semibold text-brand-secondary/80 mt-2">Pago Inicial</p>
              <p class="text-sm text-slate-600 mt-3">Con Esto Iniciamos La Construcción De Tu Página</p>
            </div>

            <div class="hidden md:flex items-center justify-center">
              <div class="flex flex-col items-center gap-2">
                <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-highlight/90 text-brand-primary font-bold ring-1 ring-brand-highlight/30 text-xs">
                  SIN RIESTOS PARA TI
                </span>
                <i data-lucide="arrow-right" class="w-6 h-6 text-brand-primary"></i>
              </div>
            </div>

            <div class="bg-slate-50 rounded-2xl ring-1 ring-slate-200 p-6 flex flex-col justify-center">
              <p class="text-sm font-bold text-slate-500">SI TE GUSTA</p>
              <p class="text-5xl sm:text-6xl font-black text-brand-primary leading-none mt-1">$170</p>
              <p class="text-sm text-slate-600 mt-2">Solo Si Estás Satisfecho Con El Resultado Final</p>
            </div>
          </div>

          <div class="mt-8 bg-emerald-50 text-emerald-900 ring-1 ring-emerald-200 rounded-2xl max-w-3xl mx-auto p-6 text-left">
            <ol class="space-y-5">
              <li class="flex items-start gap-3">
                <div>
                  <h3 class="font-black text-lg md:text-xl uppercase">Paso 1: nosotros hacemos todo el trabajo</h3>
                  <p class="text-base md:text-lg text-emerald-900/90">
                    Con tu pago inicial de $27, nuestro equipo construye tu página web completa.
                  </p>
                </div>
              </li>
              <li class="flex items-start gap-3">
                <div>
                  <h3 class="font-black text-lg md:text-xl uppercase">Paso 2: tú tienes la última palabra</h3>
                  <p class="text-base md:text-lg text-emerald-900/90">
                    Te entregamos la web para que la revises. Si estás satisfecho, <b>liquidas los $170 restantes</b>. Si no, <b>no pagas un centavo más</b>. El riesgo es completamente nuestro.
                  </p>
                </div>
              </li>
            </ol>
          </div>

          <div class="mt-8">
            <a href="#payment-section"
               class="inline-flex w-full sm:w-auto justify-center items-center gap-2 px-8 py-4 text-lg font-extrabold rounded-2xl
                      bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/20
                      hover:opacity-95 hover:translate-y-[1px] transition">
              ¡SÍ, QUIERO HACER EL PRIMER PAGO DE $27!
              <i data-lucide="arrow-right" class="w-5 h-5"></i>
            </a>

            <div class="mt-4 flex flex-wrap items-center justify-center gap-3 text-xs sm:text-sm text-gray-500">
              <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4"></i> Pago Seguro</span>
              <span class="inline-flex items-center gap-1.5"><i data-lucide="hand-coins" class="w-4 h-4"></i> Sin Sorpresas Ni Cargos Ocultos</span>
              <span class="inline-flex items-center gap-1.5"><i data-lucide="check-circle-2" class="w-4 h-4"></i> Tú Apruebas Antes De Pagar El Resto</span>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>
        
<section id="cta-section" class="py-20 md:py-24 bg-brand-primary text-white" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6 text-center">

    <!-- Icono y claim -->
    <div class="flex justify-center mb-4">
      <i data-lucide="rocket" class="w-14 h-14 md:w-16 md:h-16 text-brand-highlight"></i>
    </div>
    <p class="text-sm sm:text-base md:text-xl mt-2 text-brand-highlight font-semibold uppercase tracking-widest">
      La decisión que tomes hoy determina tus resultados de mañana
    </p>
    <h2 class="mt-2 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black uppercase leading-tight">
      En 30 días puedes seguir igual…<br class="hidden sm:block" />
      o puedes estar <span class="text-brand-highlight">atrayendo clientes</span>
    </h2>

    <!-- Badges de escasez -->
    <div class="mt-4 flex flex-wrap items-center justify-center gap-2">
      <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/20 text-xs sm:text-sm font-bold">
        <i data-lucide="flame" class="w-4 h-4"></i> La Oferta Termina Pronto
      </span>
      <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/20 text-xs sm:text-sm font-bold">
        <i data-lucide="users" class="w-4 h-4"></i> Los Cupos Son Limitados
      </span>
    </div>

    <!-- Mockup -->
    <div class="my-10 md:my-12 max-w-4xl mx-auto" data-aos="fade-up" data-aos-delay="80">
      <img src="img/Paquete-Web.webp" alt="Paquete Web LocalWebPro"
           class="w-full" loading="lazy">
    </div>

    <!-- Caja contador + cupos (badge corregido y visible) -->
    <div
      class="relative mx-auto max-w-3xl rounded-2xl shadow-2xl ring-2 ring-brand-highlight/60 p-[1px] bg-gradient-to-br from-brand-highlight/40 via-white/10 to-brand-highlight/20"
      data-aos="zoom-in" data-aos-delay="120"
      id="cta-timer-card" aria-labelledby="cta-deadline-label">

      <!-- inner glass -->
      <div class="relative rounded-2xl bg-[#0b1b33]/90 backdrop-blur-sm p-6 sm:p-8 md:p-10 pt-10 overflow-visible">
        <!-- halo decorativo -->
        <div class="pointer-events-none absolute -top-16 -right-16 w-64 h-64 bg-brand-highlight/10 rounded-full blur-3xl"></div>

        <!-- etiqueta superior (centrada y fuera del recorte) -->
        <span class="absolute -top-5 left-1/2 -translate-x-1/2 z-20 px-3 py-1 rounded-full
                     bg-brand-highlight text-[#07162D] text-xs sm:text-sm font-black uppercase
                     ring-2 ring-brand-highlight/70 shadow">
          Tu oportunidad (Tu Página Web + Bonos)
        </span>

        <p id="cta-deadline-label" class="text-xl md:text-2xl font-black text-brand-highlight uppercase leading-tight">
          La oferta termina en:
        </p>

        <!-- Countdown -->
        <div id="countdown" class="mt-4 grid grid-cols-4 gap-3 sm:gap-4">
          <div class="flex flex-col items-center bg-white/5 rounded-xl py-3 sm:py-4 ring-1 ring-white/10">
            <span id="days" class="tabular-nums text-4xl sm:text-6xl font-black leading-none">01</span>
            <span class="mt-1 text-[11px] sm:text-xs uppercase tracking-widest text-gray-300">Días</span>
          </div>
          <div class="flex flex-col items-center bg-white/5 rounded-xl py-3 sm:py-4 ring-1 ring-white/10">
            <span id="hours" class="tabular-nums text-4xl sm:text-6xl font-black leading-none">23</span>
            <span class="mt-1 text-[11px] sm:text-xs uppercase tracking-widest text-gray-300">Horas</span>
          </div>
          <div class="flex flex-col items-center bg-white/5 rounded-xl py-3 sm:py-4 ring-1 ring-white/10">
            <span id="minutes" class="tabular-nums text-4xl sm:text-6xl font-black leading-none">59</span>
            <span class="mt-1 text-[11px] sm:text-xs uppercase tracking-widest text-gray-300">Minutos</span>
          </div>
          <div class="flex flex-col items-center bg-white/5 rounded-xl py-3 sm:py-4 ring-1 ring-white/10">
            <span id="seconds" class="tabular-nums text-4xl sm:text-6xl font-black leading-none animate-pulse">17</span>
            <span class="mt-1 text-[11px] sm:text-xs uppercase tracking-widest text-gray-300">Segundos</span>
          </div>
        </div>

        <!-- Cupos restantes -->
        <div class="mt-6 text-left">
          <div class="flex items-center justify-between text-xs sm:text-sm font-semibold">
            <span class="inline-flex items-center gap-1 text-gray-300">
              <i data-lucide="ticket" class="w-4 h-4"></i>
              <span id="seats-label">Quedan <b id="left-label">12</b> De <b id="total-label">50</b> Cupos</span>
            </span>
            <span id="scarcity-tag" class="text-red-300 uppercase">Alta Demanda</span>
          </div>
          <div class="mt-2 h-3 rounded-full bg-white/10 overflow-hidden ring-1 ring-white/10"
               role="progressbar" aria-valuemin="0" aria-valuemax="50" aria-valuenow="32" id="bar-wrap">
            <div id="seats-bar" class="relative h-full rounded-full bg-gradient-to-r from-brand-highlight via-yellow-200 to-yellow-300" style="width: 64%;">
              <span class="absolute inset-0 opacity-30 bg-[linear-gradient(90deg,transparent,white,transparent)] animate-[pulse_2.8s_ease-in-out_infinite]"></span>
            </div>
          </div>
        </div>

        <!-- Nota FOMO -->
        <p class="mt-4 text-center text-sm sm:text-base font-bold text-red-300">
          Limitado a los primeros <span id="limit-cap">50</span> clientes o hasta que el reloj llegue a cero. <span class="opacity-80">(Sin Excepciones)</span>
        </p>
      </div>
    </div>

    <!-- CTA -->
    <div class="mt-8">
      <a id="cta-button" href="#oferta-irresistible"
         class="btn btn-highlight text-lg md:text-2xl btn-pulse inline-flex items-center justify-center gap-2
                px-8 py-4 rounded-2xl shadow-xl shadow-black/30 ring-2 ring-brand-highlight/60
                hover:translate-y-[1px] hover:opacity-95 transition">
        <i data-lucide="zap" class="w-5 h-5"></i>
        ¡Sí, quiero empezar con $27!
        <i data-lucide="arrow-right" class="w-5 h-5"></i>
      </a>

      <!-- Microconfianza con iconos -->
      <div class="mt-4 flex flex-wrap items-center justify-center gap-4 text-xs sm:text-sm text-white/90">
        <span class="inline-flex items-center gap-1.5">
          <i data-lucide="lock" class="w-4 h-4"></i> Compra Segura
        </span>
        <span class="inline-flex items-center gap-1.5">
          <i data-lucide="check-circle-2" class="w-4 h-4"></i> Sin Contratos
        </span>
        <span class="inline-flex items-center gap-1.5">
          <i data-lucide="headphones" class="w-4 h-4"></i> Soporte Especial
        </span>
      </div>
    </div>

  </div>
</section>

<section id="payment-section" class="py-16 md:py-24 bg-white" data-aos="fade-up">
  <div class="container mx-auto max-w-6xl px-4 sm:px-6">

    <div class="text-center max-w-4xl mx-auto">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-brand-highlight/90 text-brand-primary font-bold tracking-widest uppercase
                 ring-1 ring-brand-highlight/30 shadow-sm text-sm md:text-base">
        <i data-lucide="shopping-bag" class="w-4 h-4 md:w-5 md:h-5"></i>
        Empieza hoy con $27 — el resto solo si te gusta el resultado
      </p>

      <h2 class="mt-4 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-brand-primary uppercase leading-tight">
        Un último paso para empezar a atraer clientes potenciales
      </h2>

      <div class="mt-6 w-24 h-1.5 mx-auto rounded-full bg-brand-secondary"></div>
    </div>

    <div class="mt-14 grid lg:grid-cols-2 gap-10 md:gap-12 items-start">

      <div class="bg-gray-50 p-6 md:p-8 rounded-2xl ring-1 ring-gray-200" data-aos="fade-right">
        <h3 class="text-2xl md:text-3xl font-black text-brand-dark-text uppercase mb-6">Tu oferta especial incluye</h3>

        <div class="space-y-5">
          <div class="flex items-start gap-3">
            <i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i>
            <div>
              <p class="text-lg font-bold text-brand-dark-text">Construcción De Tu Página Web Completa</p>
              <p class="text-gray-600">Diseñada para convertir visitas en clientes, optimizada para móviles.</p>
            </div>
          </div>

          <div class="flex items-start gap-3">
            <i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i>
            <div>
              <p class="text-lg font-bold text-brand-dark-text">Garantía De Cero Riesgo</p>
              <p class="text-gray-600">Ves el resultado primero. Solo pagas el resto si estás satisfecho.</p>
            </div>
          </div>

          <div class="flex items-start gap-3">
            <i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i>
            <div>
              <p class="text-lg font-bold text-brand-dark-text">Crédito Aplicado De $27</p>
              <p class="text-gray-600">Este anticipo se descuenta del precio final de $197</p>
            </div>
          </div>
        </div>

        <div class="mt-7 grid grid-cols-1 sm:grid-cols-2 gap-4">
          <div class="relative bg-white rounded-2xl ring-2 ring-brand-secondary/60 p-6 text-center shadow-lg">
            <span class="absolute -top-3 left-1/2 -translate-x-1/2 px-3 py-1 rounded-full
                         bg-brand-secondary text-white text-xs font-black uppercase shadow">
              Hoy
            </span>
            <p class="text-6xl md:text-7xl font-black text-brand-secondary leading-none mt-2">$27</p>
            <p class="text-sm font-semibold text-brand-secondary/80 mt-2 uppercase">Pago Inicial</p>
            <p class="text-xs text-slate-500 mt-2">Adquiere Tu Página Web Ahora Mismo</p>
          </div>

          <div class="bg-white rounded-2xl ring-1 ring-gray-200 p-6 text-center">
            <p class="text-5xl font-black text-brand-primary leading-none">$170</p>
            <p class="text-sm font-semibold text-gray-500 mt-2 uppercase">Resto Al Aprobar</p>
            <p class="text-xs text-slate-500 mt-2">Solo Si Estás Satisfecho</p>
          </div>
        </div>

        <div class="mt-6 flex flex-wrap items-center gap-3 text-xs font-semibold text-gray-500">
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="flame" class="w-4 h-4"></i> Oferta Con Cupos Limitados
          </span>
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="clock-7" class="w-4 h-4"></i> Se Acaba Cuando Termine El Contador
          </span>
        </div>
      </div>

      <div class="bg-white p-6 md:p-8 items-center rounded-2xl shadow-2xl ring-1 ring-gray-200" data-aos="fade-left">
        <p class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full
                   bg-brand-secondary/90 text-brand-highlight font-bold uppercase tracking-widest
                   ring-1 ring-brand-highlight/30 text-xs">
          <i data-lucide="bolt" class="w-4 h-4"></i> Reserva Tu Lugar En 60 Segundos
        </p>

        <h3 class="mt-3 text-2xl md:text-3xl font-black text-brand-dark-text uppercase text-center">
          Finaliza tu pago y aprovecha la oferta
        </h3>

        <div class="mt-6 flex flex-col space-y-4">
          <a href="pagina-de-pagos.php?p=card" target="_blank"
             class="inline-flex items-center justify-center gap-3 w-full py-4 text-xl font-extrabold rounded-2xl
                    bg-brand-primary text-white hover:opacity-95 hover:translate-y-[1px] transition shadow-lg">
            <i data-lucide="credit-card" class="w-6 h-6"></i>
            PAGAR $27 CON TARJETA
          </a>

          <a href="pagina-de-pagos.php?p=paypal" target="_blank"
             class="inline-flex items-center justify-center gap-3 w-full py-4 text-xl font-extrabold rounded-2xl
                    bg-blue-600 hover:bg-blue-700 text-white transition shadow-lg">
            <i data-lucide="check-circle" class="w-6 h-6"></i>
            PAGAR $27 CON PAYPAL
          </a>
        </div>

        <div class="mt-8 bg-brand-primary/5 ring-1 ring-brand-primary/20 rounded-xl p-5 text-center">
          <p class="text-base md:text-lg font-black text-brand-secondary uppercase">
            NUESTRA GARANTÍA VER PARA CREER
          </p>
          <p class="text-sm md:text-base text-gray-600 mt-1">
            Construimos Tu Página Web. La Revisas Y Si Te Gusta El Resultado, Pagas El Resto. Si No, No Continuamos.
          </p>
        </div>

        <div class="mt-6 bg-brand-highlight border-l-4 border-yellow-400 p-4 rounded-r-xl">
          <p class="font-bold text-yellow-800">
            SOLO LOS PRIMEROS 50 CLIENTES ACCEDEN A ESTA OFERTA CON LOS BONUS ESPECIALES. ASEGURA TU LUGAR AHORA MISMO.
          </p>
        </div>
      </div>
    </div>

    <div class="text-center mt-10">
      <a href="#oferta-irresistible"
         class="inline-flex w-full sm:w-auto justify-center items-center gap-2 px-8 py-4 text-lg md:text-2xl font-extrabold rounded-2xl
                bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/20
                hover:opacity-95 hover:translate-y-[1px] transition">
        ¡SÍ, QUIERO EMPEZAR CON $27!
        <i data-lucide="arrow-right" class="w-5 h-5 md:w-6 md:h-6"></i>
      </a>
    </div>

    <div class="mt-4 flex flex-wrap items-center justify-center gap-4 text-xs sm:text-sm text-brand-primary/90">
      <span class="inline-flex items-center gap-1.5">
        <i data-lucide="lock" class="w-4 h-4"></i> Compra Segura
      </span>
      <span class="inline-flex items-center gap-1.5">
        <i data-lucide="check-circle-2" class="w-4 h-4"></i> Sin Contratos
      </span>
      <span class="inline-flex items-center gap-1.5">
        <i data-lucide="headphones" class="w-4 h-4"></i> Soporte Especial
      </span>
    </div>
    
  </div>
</section>

<section id="testimonials-section" class="py-16 md:py-24 bg-brand-primary">
  <div class="container mx-auto max-w-7xl px-4 sm:px-6">
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">

      <div class="video-container" data-aos="fade-right">
        <div class="relative h-0 pb-[56.25%] rounded-2xl sm:rounded-3xl overflow-hidden shadow-2xl ring-1 ring-white/10">
          <div class="pointer-events-none absolute inset-0 rounded-2xl sm:rounded-3xl ring-2 sm:ring-4 ring-brand-highlight/80"></div>

          <iframe
            class="absolute top-0 left-0 w-full h-full"
            src="https://www.youtube.com/embed/nJz7fgflh-E"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
            allowfullscreen></iframe>

          <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
        </div>

        <div class="mt-6 grid grid-cols-3 gap-3 text-center">
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="50">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">5.0</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Satisfacción</p>
          </div>
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="100">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">+250</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Proyectos</p>
          </div>
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="150">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">16 AÑOS</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Experiencia</p>
          </div>
        </div>
      </div>

      <div class="text-content text-brand-white" data-aos="fade-left" data-aos-delay="100">
        <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-brand-highlight/90 text-brand-primary font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-sm md:text-base">
          <i data-lucide="award" class="w-4 h-4"></i>
          Ayudamos a negocios como el tuyo a crecer en internet
        </div>

        <h2 class="text-3xl sm:text-4xl md:text-5xl font-black uppercase text-white leading-[1.05]">
          Mensajes de dueños de negocios que confiaron en nosotros
        </h2>
        <span class="block mt-3 h-1.5 w-16 rounded-full bg-brand-secondary"></span>

        <p class="mt-6 text-base sm:text-lg text-white/80">
          Nada mejor que escuchar a quienes ya han trabajado con nosotros. Nuestros clientes confían en nuestro compromiso, cumplimiento y el apoyo que brindamos a quienes están iniciando en el mundo digital.
        </p>

        <div class="mt-6 flex flex-wrap items-center gap-x-4 gap-y-2 text-xs text-white/70">
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="shield-check" class="w-4 h-4 text-brand-highlight"></i> Garantía Cero Riesgos
          </span>
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="badge-check" class="w-4 h-4 text-brand-highlight"></i> Resultados Verificados
          </span>
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="thumbs-up" class="w-4 h-4 text-brand-highlight"></i> Clientes Recurrentes
          </span>
        </div>
      </div>

    </div>
  </div>
</section>

<section id="faq" class="py-16 md:py-24 bg-brand-light-bg">
  <div class="container mx-auto max-w-7xl px-4 sm:px-6">

    <div class="text-center max-w-4xl mx-auto mb-12 sm:mb-16" data-aos="fade-up">
      <span class="inline-flex items-center gap-2 px-5 py-2 rounded-full bg-brand-highlight/90 text-brand-primary font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-sm md:text-base">
        <i data-lucide="help-circle" class="w-4 h-4"></i>
        ¿Tienes Dudas Antes De Realizar El Primer Pago?
      </span>

      <h2 class="mt-6 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-brand-primary uppercase leading-[1.05]">
        No queremos que tengas dudas, <span class="text-brand-secondary">queremos que tengas certezas</span> de lo que necesita tu negocio
      </h2>

      <span class="block mx-auto mt-4 h-1.5 w-32 rounded-full bg-brand-secondary"></span>
    </div>

    <div class="grid lg:grid-cols-2 gap-x-16 gap-y-12 items-start">

      <div class="lg:sticky top-24" data-aos="fade-right">
       <div class="bg-brand-primary text-white p-6 pt-10 rounded-3xl shadow-2xl ring-1 ring-brand-highlight/40 relative overflow-visible">

         <span class="absolute top-0 left-1/2 -translate-x-1/2 -translate-y-1/2
                      px-4 py-1.5 rounded-full bg-brand-highlight text-[#07162D]
                      font-black uppercase text-xs ring-2 ring-brand-highlight/70 shadow-md z-20 whitespace-nowrap">
           Garantía cero riesgos para ti
         </span>

         <div class="text-center">
           <h4 class="font-black text-2xl sm:text-3xl uppercase">Tu Inversión No Corre Riesgo</h4>
           <p class="mt-2 text-base text-white/80">Inicias Por Solo <b>$27</b>. El Resto Lo Pagas Solo Si Te Gusta El Resultado</p>
         </div>

         <div class="mt-8 flex flex-col sm:flex-row gap-4">
           <div class="bg-white/10 rounded-xl p-4 text-center flex-1">
             <i data-lucide="shield-check" class="w-8 h-8 text-emerald-400 mx-auto"></i>
             <p class="mt-2 text-sm font-bold">Cero Riesgo</p>
             <p class="text-xs text-white/70 mt-1">SI NO TE CONVENCE, NO PAGAS MÁS</p>
           </div>

           <div class="bg-white/10 rounded-xl p-4 text-center flex-1">
             <i data-lucide="clock" class="w-8 h-8 text-blue-400 mx-auto"></i>
             <p class="mt-2 text-sm font-bold">Entrega Rápida</p>
             <p class="text-xs text-white/70 mt-1">TU PÁGINA WEB LISTA EN 3 DÍAS HÁBILES</p>
           </div>

           <div class="bg-white/10 rounded-xl p-4 text-center flex-1">
             <i data-lucide="credit-card" class="w-8 h-8 text-yellow-300 mx-auto"></i>
             <p class="mt-2 text-sm font-bold">Pago Flexible</p>
             <p class="text-xs text-white/70 mt-1">$27 HOY · $170 SI TE GUSTA EL RESULTADO</p>
           </div>
         </div>

         <div class="mt-8 bg-white/5 rounded-xl p-5 text-sm">
           <h5 class="font-extrabold mb-3 text-brand-highlight uppercase">Nuestra metodología vs agencias publicitarias</h5>
           <ul class="space-y-2">
             <li class="flex items-start gap-2">
               <i data-lucide="check" class="w-5 h-5 text-emerald-400 flex-shrink-0"></i>
               <span>Con Nosotros: Pagas Completo Solo Si Te Gusta El Resultado</span>
             </li>
             <li class="flex items-start gap-2">
               <i data-lucide="x" class="w-5 h-5 text-red-400 flex-shrink-0"></i>
               <span>Con Agencias: Exigen 100% Por Adelantado O 50/50</span>
             </li>
           </ul>
         </div>

         <div class="mt-6 pt-4 border-t border-white/20 text-center">
           <a href="#payment-section"
              class="inline-flex items-center justify-center gap-2 w-full px-6 py-4 text-lg font-extrabold rounded-2xl
                     bg-brand-highlight text-[#07162D] shadow-lg shadow-black/20
                     hover:opacity-95 hover:translate-y-[1px] transition animate-pulse">
             EMPIEZA HOY CON SOLO $27
             <i data-lucide="arrow-right" class="w-5 h-5"></i>
           </a>
           <p class="mt-3 text-xs text-white/70 flex items-center justify-center gap-1">
             <i data-lucide="lock" class="w-4 h-4"></i> Compra 100% Segura · Sin Trucos Escondidos
           </p>
         </div>
       </div>
     </div>

     <div class="space-y-4" data-aos="fade-left">

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2">
             <i data-lucide="help-circle" class="w-5 h-5 text-brand-secondary"></i>
             YA INTENTÉ CON OTRA PÁGINA WEB Y EL RESULTADO NO ME GUSTÓ, ¿POR QUÉ LA TUYA SERÁ DIFERENTE?
           </span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600 space-y-3">
           <p>Nuestra página web no solo es bonita. Está <b>diseñada para ayudarte a vender</b> con textos persuasivos, estructura estratégica y bonus que hemos creado estratégicamente.</p>
           <ul class="list-disc pl-6 text-sm">
             <li>Textos creados para vender</li>
             <li>Diseño estratégico enfocado en acción</li>
             <li>Soporte humano, no bots</li>
           </ul>
         </div>
       </details>

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2">
             <i data-lucide="wallet" class="w-5 h-5 text-brand-secondary"></i>
             ¿Y SI INVIERTO LOS $27 Y TERMINO PERDIENDO DINERO?
           </span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>No puedes perder. Los $27 se descuentan del precio final.   
              Si no te gusta el resultado, no pagas los $170 restantes.   
              <b>El riesgo lo asumimos nosotros.</b> porque realizamos todo el trabajo, y eso implica tiempo, esfuerzo y dinero</p>
         </div>
       </details>

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2">
             <i data-lucide="clock-7" class="w-5 h-5 text-brand-secondary"></i>
             ¿CUÁNTO TIEMPO TARDAN EN ENTREGAR LA PÁGINA WEB?
           </span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>En <b> 3 días hábiles</b> tendrás tu web lista para revisar e indicarnos los cambios que necesitas. Rápido, porque sabemos que lo importante es <b>empezar a atraer clientes potenciales para tu negocio</b>.</p>
         </div>
       </details>

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2">
             <i data-lucide="file-text" class="w-5 h-5 text-brand-secondary"></i>
             ¿ESE PRECIO DE $197 ES REAL O LUEGO ME COBRARÁN MÁS?
           </span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>Es real: <b>un pago único</b> por tu web profesional completa.   
              Solo desde el segundo año hay un costo de <b>$125/año</b> por dominio, hosting y certificado de seguridad. Nada escondido.</p>
         </div>
       </details>

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2">
             <i data-lucide="zap" class="w-5 h-5 text-brand-secondary"></i>
             SUENA DEMASIADO BARATO PARA SER CIERTO, ¿CUÁL ES EL TRUCO ESCONDIDO?
           </span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>No hay truco. Usamos <b>nuestra plantilla profesional y estratégica</b> que personalizamos a tu negocio. Eso reduce el costo sin sacrificar calidad.</p>
         </div>
       </details>

     </div>
    </div>
  </div>
</section>


<div id="exit-intent-popup" class="hidden fixed inset-0 z-[100]">
  <div id="popup-overlay" class="absolute inset-0 bg-brand-primary backdrop-blur-md opacity-0 transition-opacity duration-300"></div>

  <div class="relative h-full w-full flex items-center justify-center p-4">
    <div id="popup-card"
         role="dialog"
         aria-modal="true"
         aria-labelledby="exit-popup-title"
         class="bg-brand-primary rounded-2xl sm:rounded-3xl shadow-2xl w-full max-w-5xl grid md:grid-cols-2 overflow-hidden 
                transform transition-all duration-300 scale-95 opacity-0">

      <div class="hidden md:block relative">
        <img src="img/Espera.webp"
             alt="Seguro Que Quieres Salir"
             class="w-full h-full object-cover" loading="lazy">
        <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
      </div>

      <div class="p-6 sm:p-8 md:p-12 text-center flex flex-col justify-center relative text-white">
        <button id="close-popup"
                class="absolute top-3 right-3 sm:right-4 h-10 w-10 rounded-full flex items-center justify-center text-white/70 hover:text-white hover:bg-white/10 transition"
                aria-label="Cerrar ventana emergente">
          &times;
        </button>

        <span class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-brand-highlight/20 text-brand-highlight font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-[11px] sm:text-xs mx-auto mb-4">
          <i data-lucide="alert-circle" class="w-4 h-4"></i>
          ¿Estás seguro de que quieres salir?
        </span>

        <h2 id="exit-popup-title" class="text-2xl sm:text-3xl lg:text-4xl font-black uppercase leading-tight">
          ¡Espera!<br><span class="text-brand-highlight">Tu Competencia</span><br>Quiere Que Te Vayas
        </h2>

        <div class="my-6 bg-white/5 ring-1 ring-white/10 rounded-2xl py-4 sm:py-6 px-4">
          <p class="text-base sm:text-lg text-white/80">Construimos Tu <strong>PÁGINA WEB</strong><br>Con Un Pago Inicial De Solo:</p>
          <p class="text-6xl sm:text-7xl font-black text-brand-highlight my-2">$27</p>
          <p class="text-base sm:text-lg text-green-400 font-semibold flex flex-col justify-center items-center gap-1">
            <span>Y PAGAS EL RESTO ($170)</span>
            <span>SOLO SI TE GUSTA EL RESULTADO</span>
          </p>
        </div>

        <div class="space-y-3">
          <a href="pagina-de-pagos.php?p=card" target="_blank"
             class="btn btn-primary w-full text-base sm:text-lg md:text-xl flex items-center justify-center gap-3 py-4 rounded-2xl shadow-lg hover:shadow-xl transition">
            <i data-lucide="credit-card" class="w-6 h-6"></i>
            PAGAR $27 CON TARJETA
          </a>

          <a href="pagina-de-pagos.php?p=paypal" target="_blank"
             class="w-full text-base sm:text-lg md:text-xl flex items-center justify-center gap-3 py-4 rounded-2xl bg-blue-600 hover:bg-blue-700 text-white shadow-lg hover:shadow-xl transition">
            <i data-lucide="check-circle" class="w-6 h-6"></i>
            PAGAR $27 CON PAYPAL
          </a>
        </div>

        <div class="mt-4 flex flex-wrap items-center justify-center gap-x-4 gap-y-1 text-xs text-white/70">
          <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4 text-brand-highlight"></i> Garantía Cero Riesgos</span>
          <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4 text-brand-highlight"></i> Pago 100% Seguro</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div id="social-proof-toast" class="fixed bottom-4 w-[90%] max-w-sm bg-brand-primary border-2 border-brand-highlight rounded-lg shadow-2xl p-4 z-50 
             left-1/2 sm:left-6 sm:-translate-x-0">
    <div class="flex items-start gap-3">
        <div class="flex-shrink-0">
            <img id="toast-image" src="" alt="Cliente Satisfecho" class="h-12 w-12 rounded-full border-2 border-white object-cover bg-gray-700" loading="lazy">
        </div>
        <div class="flex-grow">
            <p id="toast-message" class="text-white font-bold text-sm sm:text-base">Alguien De Texas Acaba De Empezar</p>
            <p class="text-xs sm:text-sm text-gray-400">Hace Unos Momentos</p>
        </div>
        <button id="close-toast" class="text-gray-500 hover:text-white text-2xl leading-none flex-shrink-0">&times;</button>
    </div>
</div>

    </main>

<footer class="bg-dark-black-bg text-white/70">
    <div class="container mx-auto max-w-7xl px-6 py-12 text-center text-sm">
        
        <div class="max-w-3xl mx-auto mb-6 text-xs text-white/50">
            <p class="font-bold uppercase">Descargo de Responsabilidad (Disclaimer)</p>
            <p class="mt-2">Este sitio no forma parte de los sitios web de Facebook™, Google™ o YouTube™.<br />Además, este sitio NO está respaldado por Facebook™, Google™ o YouTube™ de ninguna manera. FACEBOOK™ es una marca registrada de FACEBOOK, Inc. GOOGLE™ y YOUTUBE™ son marcas registradas de GOOGLE, LLC.</p>
        </div>

        <div class="pt-6 border-t border-white/10">
            <div class="flex flex-col sm:flex-row justify-center items-center gap-x-6 gap-y-2 mb-4">
                <a href="politica-de-privacidad.html" class="hover:text-white">Política De Privacidad</a>
                <a href="terminos-y-condiciones.html" class="hover:text-white">Términos Y Condiciones</a>
                <a href="contacto.html" class="hover:text-white">Contacto</a>
            </div>
            <p>© <span id="year"></span> <b>OrozDesign Multimedia. </b>Todos Los Derechos Reservados</p>
            <p class="text-xs text-white/50 mt-2">Impulsando Tu Negocio En Internet</p>
        </div>
    </div>
</footer>


    <button id="back-to-top" title="Volver Arriba">
        <i data-lucide="arrow-up" class="text-xl"></i>
    </button>


<script>
document.addEventListener('DOMContentLoaded', () => {

    // --- INICIALIZACIÓN GENERAL ---
    // Inicializar AOS (Animaciones al hacer scroll)
    if (typeof AOS !== 'undefined') {
        AOS.init({ duration: 800, once: true, offset: 50, easing: 'ease-out-cubic' });
    }
    // Inicializar Lucide Icons
    if (typeof lucide !== 'undefined') {
        lucide.createIcons();
    }
    // Actualizar el año en el footer
    const yearEl = document.getElementById('year');
    if (yearEl) {
        yearEl.textContent = new Date().getFullYear();
    }

    // --- LÓGICA DEL BOTÓN "VOLVER ARRIBA" ---
    const backToTopButton = document.getElementById('back-to-top');
    if (backToTopButton) {
        window.addEventListener('scroll', () => {
            if (window.scrollY > 300) {
                backToTopButton.classList.add('show');
            } else {
                backToTopButton.classList.remove('show');
            }
        });
        backToTopButton.addEventListener('click', () => {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
    }

    // --- LÓGICA DEL MENÚ MÓVIL ---
    const menuToggle = document.getElementById('menu-toggle');
    const mobileMenu = document.getElementById('mobile-menu');
    const closeButton = document.getElementById('mm-close');
    const backdrop = document.getElementById('mm-backdrop');
    const menuLinks = document.querySelectorAll('#mobile-menu nav a');
    const body = document.body;

    const openMenu = () => {
        if (mobileMenu) {
            mobileMenu.classList.remove('hidden');
            body.style.overflow = 'hidden';
        }
    };
    const closeMenu = () => {
        if (mobileMenu) {
            mobileMenu.classList.add('hidden');
            body.style.overflow = '';
        }
    };

    if (menuToggle) menuToggle.addEventListener('click', openMenu);
    if (closeButton) closeButton.addEventListener('click', closeMenu);
    if (backdrop) backdrop.addEventListener('click', closeMenu);
    menuLinks.forEach(link => link.addEventListener('click', closeMenu));
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && mobileMenu && !mobileMenu.classList.contains('hidden')) {
            closeMenu();
        }
    });

    // --- LÓGICA DEL POPUP DE INTENCIÓN DE SALIDA ---
    const popup = document.getElementById('exit-intent-popup');
    if (popup) {
        const popupOverlay = document.getElementById('popup-overlay');
        const popupCard = document.getElementById('popup-card');
        const popupCloseButton = document.getElementById('close-popup');
        const popupLinks = document.querySelectorAll('#exit-intent-popup a');
        let popupShown = false;

        const showPopup = () => {
            if (popupShown) return;
            popupShown = true;
            popup.classList.remove('hidden');
            setTimeout(() => {
                if (popupOverlay) popupOverlay.classList.remove('opacity-0');
                if (popupCard) popupCard.classList.remove('scale-95', 'opacity-0');
            }, 50);
        };
        const hidePopup = () => {
            if (!popupShown) return;
            popupShown = false;
            if (popupOverlay) popupOverlay.classList.add('opacity-0');
            if (popupCard) popupCard.classList.add('scale-95', 'opacity-0');
            setTimeout(() => popup.classList.add('hidden'), 300);
        };

        document.addEventListener('mouseout', e => { if (e.clientY < 20) showPopup(); });

        let hasScrolledDeep = false;
        const scrollTriggerPoint = 800;
        document.addEventListener('scroll', () => {
            const currentScrollY = window.scrollY;
            if (!hasScrolledDeep && currentScrollY > scrollTriggerPoint) hasScrolledDeep = true;
            if (hasScrolledDeep && currentScrollY < 50) {
                showPopup();
                hasScrolledDeep = false;
            }
        }, { passive: true });

        if (popupCloseButton) popupCloseButton.addEventListener('click', hidePopup);
        if (popupOverlay) popupOverlay.addEventListener('click', hidePopup);
        popupLinks.forEach(link => link.addEventListener('click', hidePopup));
        document.addEventListener('keydown', e => { if (e.key === 'Escape' && popupShown) hidePopup(); });
    }

    // --- LÓGICA DE LA NOTIFICACIÓN DE PRUEBA SOCIAL ---
    const toastElement = document.getElementById('social-proof-toast');
    if (toastElement) {
        const messageElement = document.getElementById('toast-message');
        const imageElement = document.getElementById('toast-image');
        const closeToastButton = document.getElementById('close-toast');
        const clients = [
            { name: "Maria S. De Houston, TX", image: "clientes/MariaS.webp" },
            { name: "John D. De Miami, FL", image: "clientes/JohnD.webp" },
            { name: "Carlos R. De Los Angeles, CA", image: "clientes/CarlosR.webp" }
        ];

        const showToast = () => {
            const randomClient = clients[Math.floor(Math.random() * clients.length)];
            const finalMessage = `${randomClient.name} Acaba De Realizar Su Pago Inicial De $27`;
            messageElement.textContent = finalMessage;
            imageElement.src = randomClient.image;
            toastElement.classList.remove('hidden');
            toastElement.classList.add('show');
            setTimeout(() => toastElement.classList.remove('show'), 6000);
        };

        if (closeToastButton) closeToastButton.addEventListener('click', () => toastElement.classList.remove('show'));

        const startToastCycle = () => {
            const randomInterval = Math.floor(Math.random() * (22000 - 9000 + 1)) + 9000;
            setTimeout(() => {
                showToast();
                startToastCycle();
            }, randomInterval);
        };
        setTimeout(startToastCycle, 12000);
    }
    
    // --- LÓGICA DEL CONTADOR Y CUPOS ---
    const countdownCard = document.getElementById('cta-timer-card');
    if (countdownCard) {
        const dEl = document.getElementById('days');
        const hEl = document.getElementById('hours');
        const mEl = document.getElementById('minutes');
        const sEl = document.getElementById('seconds');
        const deadline = new Date(Date.now() + 48 * 60 * 60 * 1000);

        const updateTimer = () => {
            const diff = deadline - new Date();
            if (diff <= 0) {
                dEl.textContent = '00';
                hEl.textContent = '00';
                mEl.textContent = '00';
                sEl.textContent = '00';
                clearInterval(timerInterval);
                return;
            }
            dEl.textContent = String(Math.floor(diff / (1000*60*60*24))).padStart(2, '0');
            hEl.textContent = String(Math.floor((diff / (1000*60*60)) % 24)).padStart(2, '0');
            mEl.textContent = String(Math.floor((diff / (1000*60)) % 60)).padStart(2, '0');
            sEl.textContent = String(Math.floor((diff / 1000) % 60)).padStart(2, '0');
        };

        const timerInterval = setInterval(updateTimer, 1000);
    }

});
</script>

<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
      {
        "@type": "Question",
        "name": "¿Cuál es la diferencia entre el pago de $27 y $170?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Los $27 son un pago inicial de confianza para construir tu web completa. Los $170 restantes se pagan solo al final si estás 100% satisfecho."
        }
      },
      {
        "@type": "Question",
        "name": "Ya pagué por una web y no funcionó. ¿Qué es diferente?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Nuestra web es una herramienta de negocio con estrategia de conversión, textos persuasivos y bonos para potenciar resultados, no solo un diseño bonito."
        }
      },
      {
        "@type": "Question",
        "name": "¿Qué pasa si pago los $27 y no me gusta el sitio web?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Nada. Si el resultado no te encanta, no pagas el resto. Sin contratos ni explicaciones."
        }
      },
      {
        "@type": "Question",
        "name": "¿En cuánto tiempo entregan mi página web?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Tu web queda lista para revisión en 2–3 días hábiles desde que entregas la información."
        }
      },
      {
        "@type": "Question",
        "name": "El precio de $197, ¿es un pago único?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Sí. El diseño y construcción ($27 + $170) es un pago único. Desde el segundo año, la cuota anual de $125 mantiene dominio, hosting y certificación activa."
        }
      },
      {
        "@type": "Question",
        "name": "¿Incluye textos, imágenes y optimización para móviles?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Sí. Incluye copy de ventas, imágenes acordes a tu rubro y diseño responsive pensado para convertir en celulares."
        }
      },
      {
        "@type": "Question",
        "name": "¿El dominio y la web quedan a mi nombre?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Sí. El dominio y el sitio quedan a tu nombre. Te aseguramos el control de tus activos digitales."
        }
      }
    ]
}
</script>
</body>
</html>